/*
    This file is part of W3ZMapEditor (c).

    W3ZMapEditor is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    W3ZMapEditor is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with W3ZMapEditor; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
// Targa.h: interface for the CTarga class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TARGA_H__39B3FF1E_059B_495E_8DD2_7D77B404BA47__INCLUDED_)
#define AFX_TARGA_H__39B3FF1E_059B_495E_8DD2_7D77B404BA47__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

const byte TGA_TYPE_NOIMAGE				= 0; // No Image Data Included
const byte TGA_TYPE_UNCOMP_COLORMAP		= 1; // Uncompressed, Color-mapped Image
const byte TGA_TYPE_UNCOMP_RGB			= 2; // Uncompressed, True-color Image (war3 standard)
const byte TGA_TYPE_UNCOMP_BW			= 3; // Uncompressed, Black-and-white Image
const byte TGA_TYPE_RLE_COLORMAP		= 9; // Run-length encoded, Color-mapped Image
const byte TGA_TYPE_RLE_RGB				= 10; // Run-length encoded, True-color Image
const byte TGA_TYPE_RLG_BW				= 11; // Run-length encoded, Black-and-white Image
const byte TGA_IMG_STARTS_BOTTOM_LEFT	= 0x00;//bottom left
const byte TGA_IMG_STARTS_BOTTOM_RIGHT	= 0x10;//bottom right
const byte TGA_IMG_STARTS_TOP_LEFT		= 0x20;//top left
const byte TGA_IMG_STARTS_TOP_RIGHT		= 0x30;//top right
const byte TGA_IMG_WAR3_FORMAT			= 0x28; // war3 image origin and alpha channel bit
const int TGA_MAX_WIDTH					= 32768;
const int TGA_MAX_HEIGHT				= 32768;

const char STR_TRUEVISION[] = "\0\0\0\0\0\0\0\0TRUEVISION-XFILE Generated by W3Z Map Editor";
const int STR_TRUEVISION_LEN = strlen(STR_TRUEVISION);

class CTarga  
{
public:
	CByteArray m_baUnsupportedBuffer;
	byte* GetBitmapPtr();
	int GetHeight();
	int GetWidth();
	void SetSize(int width, int height);
	CTarga();
	virtual ~CTarga();
protected:
// Image Data
	byte* m_pBitmap;
// Color Map Data
	byte* m_pColorMap;
// Image ID 
	byte* m_pImageID;
// Image Spec 10 bytes
	byte m_ImgDesc;
	byte m_PixelDepth;
	short m_Height;
	short m_Width;
	short m_YOrg;
	short m_XOrg;
//	Color Map Spec 5 bytes
	byte m_ColorMapEntrySize;
	short m_ColorMapLength;
	short m_FirstEntryIndex;
//
	byte m_ImageType;
	byte m_ColorMapType;
	byte m_IDLength;
};

#endif // !defined(AFX_TARGA_H__39B3FF1E_059B_495E_8DD2_7D77B404BA47__INCLUDED_)
