using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Warcraft III Autorefresh by Jason Ureta (AKA SentryIII)
// Developed using Microsoft Visual C# .NET under the Microsoft .NET Framework 1.1.
//
// DISCLAIMER: For use on Blizzard's Battle.net Service.
// The author will not be held responsible for damages incurred, including but not limited to the banning and/or disabling of your CD-key,
// any hardware or software malfunction or destruction related to the usage of this application, or any other problems that would prevent
// you from playing Warcraft III on Battle.net. If the source code is modified in any way, the author credits and this disclaimer must
// remain accessible to users.
//
////////////////////////////////////////////////////////////////////////////////////////////////////
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Blizzard Entertainment, Battle.net, and Warcraft are trademarks or registered trademarks of Blizzard Entertainment in the U.S.
// and/or other countries. Visual C# is a registered trademark of Microsoft Corporation in the U.S. and/or other countries.
// All other trademarks are the property of their respective owners.
//
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace WarcraftIIIAutoRefresh
{
	/// <summary>
	/// Summary description for NameWindow.
	/// </summary>
	public class NameWindow : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Button btnEditNames;
		private System.Windows.Forms.RadioButton rdoOpt1;
		private System.Windows.Forms.RadioButton rdoOpt2;
		private System.Windows.Forms.RadioButton rdoOpt3;
		private System.Windows.Forms.RadioButton rdoOpt4;
		private System.Windows.Forms.RadioButton rdoOpt5;
		private System.Windows.Forms.GroupBox grpOptions;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Button btnOK;
		private System.Windows.Forms.Button btnCancel;

		public ArrayList NameList;
		
		public delegate void d_NameList(ArrayList p_NameList);
		public event d_NameList OnModifyNameList;
		public delegate void d_Option(int p_Option);
		public event d_Option OnModifyOption;

		public int NameOption
		{
			get
			{
				if(rdoOpt1.Checked) return 1;
				if(rdoOpt2.Checked) return 2;
				if(rdoOpt3.Checked) return 3;
				if(rdoOpt4.Checked) return 4;
				if(rdoOpt5.Checked) return 5;
				return 0;
			}
			set
			{
				switch(value)
				{
					case 1:
					{
						rdoOpt1.Checked = true;
						break;
					}
					case 2:
					{
						rdoOpt2.Checked = true;
						break;
					}
					case 3:
					{
						rdoOpt3.Checked = true;
						break;
					}
					case 4:
					{
						rdoOpt4.Checked = true;
						break;
					}
					case 5:
					{
						rdoOpt5.Checked = true;
						break;
					}
				}
			}
		}

		public NameWindow(ArrayList p_NameList)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			NameList = p_NameList;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.grpOptions = new System.Windows.Forms.GroupBox();
			this.btnEditNames = new System.Windows.Forms.Button();
			this.rdoOpt1 = new System.Windows.Forms.RadioButton();
			this.label1 = new System.Windows.Forms.Label();
			this.rdoOpt2 = new System.Windows.Forms.RadioButton();
			this.label2 = new System.Windows.Forms.Label();
			this.rdoOpt3 = new System.Windows.Forms.RadioButton();
			this.rdoOpt4 = new System.Windows.Forms.RadioButton();
			this.rdoOpt5 = new System.Windows.Forms.RadioButton();
			this.btnOK = new System.Windows.Forms.Button();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpOptions.SuspendLayout();
			this.SuspendLayout();
			// 
			// grpOptions
			// 
			this.grpOptions.Controls.Add(this.btnEditNames);
			this.grpOptions.Controls.Add(this.rdoOpt1);
			this.grpOptions.Controls.Add(this.label1);
			this.grpOptions.Controls.Add(this.rdoOpt2);
			this.grpOptions.Controls.Add(this.label2);
			this.grpOptions.Controls.Add(this.rdoOpt3);
			this.grpOptions.Controls.Add(this.rdoOpt4);
			this.grpOptions.Controls.Add(this.rdoOpt5);
			this.grpOptions.Location = new System.Drawing.Point(16, 24);
			this.grpOptions.Name = "grpOptions";
			this.grpOptions.Size = new System.Drawing.Size(328, 224);
			this.grpOptions.TabIndex = 0;
			this.grpOptions.TabStop = false;
			this.grpOptions.Text = "Names";
			// 
			// btnEditNames
			// 
			this.btnEditNames.Location = new System.Drawing.Point(208, 152);
			this.btnEditNames.Name = "btnEditNames";
			this.btnEditNames.Size = new System.Drawing.Size(104, 40);
			this.btnEditNames.TabIndex = 2;
			this.btnEditNames.Text = "Edit Names";
			this.btnEditNames.Click += new System.EventHandler(this.btnEditNames_Click);
			// 
			// rdoOpt1
			// 
			this.rdoOpt1.Location = new System.Drawing.Point(24, 48);
			this.rdoOpt1.Name = "rdoOpt1";
			this.rdoOpt1.Size = new System.Drawing.Size(224, 24);
			this.rdoOpt1.TabIndex = 1;
			this.rdoOpt1.Text = "\"AutoRefresh\" (Grey, Single Name)";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 24);
			this.label1.Name = "label1";
			this.label1.TabIndex = 0;
			this.label1.Text = "Presets";
			// 
			// rdoOpt2
			// 
			this.rdoOpt2.Location = new System.Drawing.Point(24, 72);
			this.rdoOpt2.Name = "rdoOpt2";
			this.rdoOpt2.Size = new System.Drawing.Size(224, 24);
			this.rdoOpt2.TabIndex = 1;
			this.rdoOpt2.Text = "Download Only (White, Multiple Names)";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 112);
			this.label2.Name = "label2";
			this.label2.TabIndex = 0;
			this.label2.Text = "Custom";
			// 
			// rdoOpt3
			// 
			this.rdoOpt3.Location = new System.Drawing.Point(24, 136);
			this.rdoOpt3.Name = "rdoOpt3";
			this.rdoOpt3.Size = new System.Drawing.Size(168, 24);
			this.rdoOpt3.TabIndex = 1;
			this.rdoOpt3.Text = "Grey (15 Characters Long)";
			// 
			// rdoOpt4
			// 
			this.rdoOpt4.Location = new System.Drawing.Point(24, 160);
			this.rdoOpt4.Name = "rdoOpt4";
			this.rdoOpt4.Size = new System.Drawing.Size(168, 24);
			this.rdoOpt4.TabIndex = 1;
			this.rdoOpt4.Text = "White (13 Characters Long)";
			// 
			// rdoOpt5
			// 
			this.rdoOpt5.Location = new System.Drawing.Point(24, 184);
			this.rdoOpt5.Name = "rdoOpt5";
			this.rdoOpt5.Size = new System.Drawing.Size(168, 24);
			this.rdoOpt5.TabIndex = 1;
			this.rdoOpt5.Text = "Color (5 Characters Long)";
			// 
			// btnOK
			// 
			this.btnOK.Location = new System.Drawing.Point(64, 264);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(96, 32);
			this.btnOK.TabIndex = 1;
			this.btnOK.Text = "OK";
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Location = new System.Drawing.Point(200, 264);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.Size = new System.Drawing.Size(96, 32);
			this.btnCancel.TabIndex = 1;
			this.btnCancel.Text = "Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// NameWindow
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(360, 312);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpOptions);
			this.Controls.Add(this.btnCancel);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "NameWindow";
			this.ShowInTaskbar = false;
			this.Text = "Name Options";
			this.grpOptions.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void btnEditNames_Click(object sender, System.EventArgs e)
		{
			CustomNameEditor thisEditor = new CustomNameEditor(NameList);
			thisEditor.OnModifyNameList += new WarcraftIIIAutoRefresh.CustomNameEditor.d_NameList(thisEditor_OnModifyNameList);
			thisEditor.ShowDialog(this);
		}

		private void thisEditor_OnModifyNameList(ArrayList p_NameList)
		{
			NameList = p_NameList;
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			OnModifyNameList(NameList);
			OnModifyOption(NameOption);
			this.Close();
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}
	}
}
