using System;
using System.Net.Sockets;
using System.IO;
using System.Diagnostics;
using System.Runtime.InteropServices;
using System.Threading;

////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Warcraft III Autorefresh by Jason Ureta (AKA SentryIII)
// Developed using Microsoft Visual C# .NET under the Microsoft .NET Framework 1.1.
//
// DISCLAIMER: For use on Blizzard's Battle.net Service.
// The author will not be held responsible for damages incurred, including but not limited to the banning and/or disabling of your CD-key,
// any hardware or software malfunction or destruction related to the usage of this application, or any other problems that would prevent
// you from playing Warcraft III on Battle.net. If the source code is modified in any way, the author credits and this disclaimer must
// remain accessible to users.
//
////////////////////////////////////////////////////////////////////////////////////////////////////
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Blizzard Entertainment, Battle.net, and Warcraft are trademarks or registered trademarks of Blizzard Entertainment in the U.S.
// and/or other countries. Visual C# is a registered trademark of Microsoft Corporation in the U.S. and/or other countries.
// All other trademarks are the property of their respective owners.
//
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace WarcraftIIIAutoRefresh
{
	/// <summary>
	/// Summary description for SubSystem.
	/// </summary>
	public class SubSystem
	{
//
//		[DllImport("kernel32.dll")]
//		private static extern IntPtr OpenProcess(
//			uint dwDesiredAccess, 
//			Int32 bInheritHandle, 
//			uint dwProcessId
//			);
//
//		[DllImport("kernel32.dll")]
//		private static extern int ReadProcessMemory(
//			IntPtr hProcess, 
//			IntPtr lpBaseAddress,
//			[In, Out] byte[] buffer, 
//			uint size, 
//			out IntPtr lpNumberOfBytesRead
//			);
//
//		[DllImport("kernel32.dll")] private static extern int CloseHandle(
//			IntPtr hObject
//			);
//
//		public const uint PROCESS_VM_READ = (0x0010);
//		public const string PROCESS_WAR3 = "war3";
//
////		private byte[] HostCounter;
//		private byte[] GameChecksum;
//
//		private const int ADDR_HOSTCOUNTER	= (int) 0x6F87EE78;
//		private const int ADDR_GAMECHECKSUM	= (int) 0x6F87E60C;
//
////		private const uint ADDR_HOSTCOUNTER		= 0x6F87EE78;
////		private const uint ADDR_GAMECHECKSUM	= 0x6F87E60C;
//
//		private void ReadChecksum()
//		{
//			try
//			{
//				uint ProcessId = (uint) Process.GetProcessesByName(PROCESS_WAR3)[0].Id;
//				IntPtr hProcess = OpenProcess(PROCESS_VM_READ, 1, ProcessId);
//
//				IntPtr ptrBytesRead;
//				IntPtr MemoryAddress;
//			
//				MemoryAddress = new IntPtr(ADDR_HOSTCOUNTER);
////				HostCounter = new byte[1];
////				ReadProcessMemory(hProcess, MemoryAddress, HostCounter, 1, out ptrBytesRead);
//				MemoryAddress = new IntPtr(ADDR_GAMECHECKSUM);
//				GameChecksum = new byte[4];
//				ReadProcessMemory(hProcess, MemoryAddress, GameChecksum, 4, out ptrBytesRead);
//
//				CloseHandle(hProcess);
//			}
//			catch
//			{
//				m_PortNumber = 0;
//				throw new Exception("Warcraft III is no longer currently running, or is not detected.");
//			}
//		}
//
//		private const uint ADDR_PORTNUMBER	= 0x6F87E654;
//
//		private void DetectPortNumber()
//		{
//			try
//			{
//								uint ProcessId = (uint) Process.GetProcessesByName(PROCESS_WAR3)[0].Id;
//								IntPtr hProcess = OpenProcess(PROCESS_VM_READ, 1, ProcessId);
//							
//								IntPtr ptrBytesRead;
//								IntPtr MemoryAddress;
//							
//								MemoryAddress = new IntPtr(ADDR_PORTNUMBER);
//								byte[] PortNumber = new byte[4];
//								ReadProcessMemory(hProcess, MemoryAddress, PortNumber, 4, out ptrBytesRead);
//				
//								m_PortNumber = (int) PortNumber[0] + (PortNumber[1] * 256);
//				
//								CloseHandle(hProcess);
//			}
//			catch(Exception ex)
//			{
//				Debug.Write(ex.Source + " - " + ex.Message);
//			}
//		}


		public const int MAX_SLOTS = 12;
		public const string CONFIG_FILENAME = "\\WarcraftIIIAutoRefresh_Config.dat";

		private bool m_IsRefreshRunning;
		private int m_PortNumber;
		private int m_RefreshRate;
		private int m_RefreshTimer;
		private bool m_IsDownloadOnly;
		private string m_LogString;
		private string m_Message;


		public bool IsRefreshRunning
		{
			get { return m_IsRefreshRunning; }
		}

		public int PortNumber
		{
			get { return m_PortNumber; }
			set
			{
				if(value > 65535) value = 65535;
				if(value < 1) value = 1;
				m_PortNumber = value;
				UpdateLog(DateTime.Now.ToString() + " - Setting port number to " + value.ToString() + ".\r\n");
			}
		}

		public int RefreshRate
		{
			get { return m_RefreshRate; }
			set
			{
				if(value > 60) value = 60;
				if(value < 5) value = 5;
				m_RefreshRate = value * 1000;
				if(m_RefreshTimer > m_RefreshRate) m_RefreshTimer = m_RefreshRate;
				UpdateLog(DateTime.Now.ToString() + " - Setting refresh rate to " + value.ToString() + " seconds.\r\n");
			}
		}

		public bool IsDownloadOnly
		{
			get { return m_IsDownloadOnly; }
			set
			{
				m_IsDownloadOnly = value;
				if(value)
					UpdateLog(DateTime.Now.ToString() + " - Setting to download only game. (Player Name: Multiple)\r\n");
				else
					UpdateLog(DateTime.Now.ToString() + " - Setting to playable game. (Player Name: \"AutoRefresh\")\r\n");
			}
		}

		public string LogString
		{
			get { return m_LogString; }
		}

		public string Message
		{
			get { return m_Message; }
			set { m_Message = value; }
		}

		public enum GameSlotState
		{
			Available,
			Full,
			Started
		}

		private GameSlotState m_GameState;

		private ColorName[] m_NameList;
		private int m_NameOption;

		public ColorName[] NameList
		{
			get { return m_NameList; }
			set { m_NameList = value; }
		}

		public int NameOption
		{
			get { return m_NameOption; }
			set { m_NameOption = value; }
		}

		public delegate void d_UpdateLog();
		public event d_UpdateLog OnUpdateLog;

		private AutoResetEvent m_InitEvent;

		public AutoResetEvent InitEvent
		{
			get { return m_InitEvent; }
		}

		public SubSystem()
		{
			ResetToDefaults();
			m_InitEvent = new AutoResetEvent(false);
			m_NameList = new ColorName[0];
		}

		public void ResetToDefaults()
		{
			m_RefreshRate = 15000;
			m_PortNumber = 6112;
			m_IsDownloadOnly = false;
		}

		private void UpdateLog(string Message)
		{
			string exString = Message;
			m_LogString += exString;
			m_Message = exString;
			OnUpdateLog();
		}

		public void ReadConfigFile()
		{
			string thisPath = System.Environment.CurrentDirectory + CONFIG_FILENAME;
			FileStream thisFile = null;
			BinaryReader thisReader = null;
			if(File.Exists(thisPath))
			{
				try
				{
					int NameCount;
					thisFile = new FileStream(thisPath, FileMode.Open, FileAccess.Read);
					thisReader = new BinaryReader(thisFile);
					m_RefreshRate = thisReader.ReadInt32();
					m_PortNumber = thisReader.ReadInt32();
					m_NameOption = thisReader.ReadInt32();
					NameCount = thisReader.ReadInt32();
					m_NameList = new ColorName[NameCount];
					for(int i = 0; i < NameCount; i++)
					{
						m_NameList[i].Name = thisReader.ReadString();
						m_NameList[i].Color = thisReader.ReadString();
					}
					UpdateLog(DateTime.Now.ToString() + " - Previous settings loaded.\r\n");
				}
				catch
				{
					ResetToDefaults();
				}
				finally
				{
					if(thisReader != null) thisReader.Close();
					if(thisFile != null) thisFile.Close();
				}
			}
		}
		public void WriteConfigFile()
		{
			string thisPath = System.Environment.CurrentDirectory + CONFIG_FILENAME;
			FileStream thisFile = null;
			BinaryWriter thisWriter = null;
			try
			{
				thisFile = new FileStream(thisPath, FileMode.Create, FileAccess.Write);
				thisWriter = new BinaryWriter(thisFile);
				thisWriter.Write(m_RefreshRate);
				thisWriter.Write(m_PortNumber);
				thisWriter.Write(m_NameOption);
				thisWriter.Write(m_NameList.Length);
				for(int i = 0; i < m_NameList.Length; i++)
				{
					thisWriter.Write(m_NameList[i].Name);
					thisWriter.Write(m_NameList[i].Color);
				}
			}
			catch {}
			finally
			{
				if(thisWriter != null) thisWriter.Close();
				if(thisFile != null) thisFile.Close();
			}
		}

		private byte[] CreateJoinPacket(string Name, bool IsWhite, byte HostCounter)
		{
			string FullName;
			if(IsWhite)
				FullName = "|r" + Name;
			else
				FullName = Name;
			if(FullName.Length > 15)
				FullName = FullName.Substring(0,15);

			byte LengthCheck = (byte) (38 + FullName.Length);

			byte[] JoinPacket = new byte[LengthCheck];

			JoinPacket[0] = 0xF7;
			JoinPacket[1] = 0x1E;
			JoinPacket[2] = LengthCheck;
			JoinPacket[3] = 0x00;
			JoinPacket[4] = HostCounter;
			JoinPacket[5] = 0x00;
			JoinPacket[6] = 0x00;
			JoinPacket[7] = 0x00;
			JoinPacket[8] = 0x00;
			JoinPacket[9] = 0x00;
			JoinPacket[10] = 0x00;
			JoinPacket[11] = 0x00;
			JoinPacket[12] = 0x00;
			JoinPacket[13] = 0xE4;
			JoinPacket[14] = 0x17;
			JoinPacket[15] = 0x00;
			JoinPacket[16] = 0x00;
			JoinPacket[17] = 0x00;
			JoinPacket[18] = 0x00;

			int i;
			for(i = 0; i < FullName.Length; i++)
				JoinPacket[19+i] = Convert.ToByte(FullName[i]);

			JoinPacket[19+i] = 0x00;
			JoinPacket[20+i] = 0x01;
			JoinPacket[21+i] = 0x00;
			JoinPacket[22+i] = 0x02;
			JoinPacket[23+i] = 0x00;
			JoinPacket[24+i] = 0x17;
			JoinPacket[25+i] = 0xE0;
			JoinPacket[26+i] = 0x7F;
			JoinPacket[27+i] = 0x00;
			JoinPacket[28+i] = 0x00;
			JoinPacket[29+i] = 0x01;
			JoinPacket[30+i] = 0x00;
			JoinPacket[31+i] = 0x00;
			JoinPacket[32+i] = 0x00;
			JoinPacket[33+i] = 0x00;
			JoinPacket[34+i] = 0x00;
			JoinPacket[35+i] = 0x00;
			JoinPacket[36+i] = 0x00;
			JoinPacket[37+i] = 0x00;

			return JoinPacket;
		}
		private byte[] CreateJoinPacket(string Name, string Color, byte HostCounter)
		{
			string FullName = "|c00" + Color + Name;

			if(FullName.Length > 15)
				FullName = FullName.Substring(0,15);

			byte LengthCheck = (byte) (38 + FullName.Length);

			byte[] JoinPacket = new byte[LengthCheck];

			JoinPacket[0] = 0xF7;
			JoinPacket[1] = 0x1E;
			JoinPacket[2] = LengthCheck;
			JoinPacket[3] = 0x00;
			JoinPacket[4] = HostCounter;
			JoinPacket[5] = 0x00;
			JoinPacket[6] = 0x00;
			JoinPacket[7] = 0x00;
			JoinPacket[8] = 0x00;
			JoinPacket[9] = 0x00;
			JoinPacket[10] = 0x00;
			JoinPacket[11] = 0x00;
			JoinPacket[12] = 0x00;
			JoinPacket[13] = 0xE4;
			JoinPacket[14] = 0x17;
			JoinPacket[15] = 0x00;
			JoinPacket[16] = 0x00;
			JoinPacket[17] = 0x00;
			JoinPacket[18] = 0x00;

			int i;
			for(i = 0; i < FullName.Length; i++)
				JoinPacket[19+i] = Convert.ToByte(FullName[i]);

			JoinPacket[19+i] = 0x00;
			JoinPacket[20+i] = 0x01;
			JoinPacket[21+i] = 0x00;
			JoinPacket[22+i] = 0x02;
			JoinPacket[23+i] = 0x00;
			JoinPacket[24+i] = 0x17;
			JoinPacket[25+i] = 0xE0;
			JoinPacket[26+i] = 0x7F;
			JoinPacket[27+i] = 0x00;
			JoinPacket[28+i] = 0x00;
			JoinPacket[29+i] = 0x01;
			JoinPacket[30+i] = 0x00;
			JoinPacket[31+i] = 0x00;
			JoinPacket[32+i] = 0x00;
			JoinPacket[33+i] = 0x00;
			JoinPacket[34+i] = 0x00;
			JoinPacket[35+i] = 0x00;
			JoinPacket[36+i] = 0x00;
			JoinPacket[37+i] = 0x00;

			return JoinPacket;
		}

		public void RefreshCycle()
		{
			ReadConfigFile();
			m_InitEvent.Set();
			m_IsRefreshRunning = true;
			m_GameState = GameSlotState.Available;
			//			DetectPortNumber();


			UpdateLog(DateTime.Now.ToString() + " - Initialized Autorefresh.\r\n");

			int NameCounter = 0;
			int HostCounter = 0;
			bool SuccessfulRefresh = false;

			while(m_IsRefreshRunning)
			{
				try
				{
					TcpClient[] DummyClients = new TcpClient[MAX_SLOTS];
					NetworkStream[] DummyStreams = new NetworkStream[MAX_SLOTS];
					BinaryReader[] DummyReaders = new BinaryReader[MAX_SLOTS];
					BinaryWriter[] DummyWriters = new BinaryWriter[MAX_SLOTS];
					int SlotsUsed = 0;
					try
					{
						m_GameState = GameSlotState.Available;
						for(int i = 0; i < MAX_SLOTS-1 && m_GameState == GameSlotState.Available && m_IsRefreshRunning; i++)
						{
							DummyClients[i] = new TcpClient("localhost",m_PortNumber);
							DummyStreams[i] = DummyClients[i].GetStream();
							DummyReaders[i] = new BinaryReader(DummyStreams[i]);
							DummyWriters[i] = new BinaryWriter(DummyStreams[i]);

							byte[] JoinPacket;
							switch(m_NameOption)
							{
								case 2:
								{
									switch(NameCounter)
									{
										case 1:
										{
											JoinPacket = new byte[53] {
																		  0xF7, 0x1E, 0x35, 0x00, (byte) HostCounter, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE4, 0x17, 0x00,
																		  0x00, 0x00, 0x00, 0x7C, 0x72, 0x4E, 0x4F, 0x20, 0x47, 0x41, 0x4D, 0x45, 0x20, 0x53, 0x54, 0x41,
																		  0x52, 0x54, 0x00, 0x01, 0x00, 0x02, 0x00, 0x17, 0xE0, 0x7F, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
																		  0x00, 0x00, 0x00, 0x00, 0x00
																	  };
											break;
										}
										case 2:
										{
											JoinPacket = new byte[53] {
																		  0xF7, 0x1E, 0x35, 0x00, (byte) HostCounter, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE4, 0x17, 0x00,
																		  0x00, 0x00, 0x00, 0x7C, 0x72, 0x48, 0x4F, 0x53, 0x54, 0x20, 0x49, 0x53, 0x20, 0x41, 0x46, 0x4B,
																		  0x21, 0x21, 0x00, 0x01, 0x00, 0x02, 0x00, 0x17, 0xE0, 0x7F, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
																		  0x00, 0x00, 0x00, 0x00, 0x00
																	  };
											break;
										}
										case 3:
										{
											JoinPacket = new byte[53] {
																		  0xF7, 0x1E, 0x35, 0x00, (byte) HostCounter, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE4, 0x17, 0x00,
																		  0x00, 0x00, 0x00, 0x7C, 0x72, 0x44, 0x4C, 0x20, 0x41, 0x4E, 0x44, 0x20, 0x4C, 0x45, 0x41, 0x56,
																		  0x45, 0x21, 0x00, 0x01, 0x00, 0x02, 0x00, 0x17, 0xE0, 0x7F, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
																		  0x00, 0x00, 0x00, 0x00, 0x00
																	  };
											break;
										}
										default:
										{
											JoinPacket = new byte[53] {
																		  0xF7, 0x1E, 0x35, 0x00, (byte) HostCounter, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE4, 0x17, 0x00,
																		  0x00, 0x00, 0x00, 0x7C, 0x72, 0x44, 0x4F, 0x57, 0x4E, 0x4C, 0x4F, 0x41, 0x44, 0x20, 0x4F, 0x4E,
																		  0x4C, 0x59, 0x00, 0x01, 0x00, 0x02, 0x00, 0x17, 0xE0, 0x7F, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
																		  0x00, 0x00, 0x00, 0x00, 0x00
																	  };
											break;
										}
									}
									NameCounter = ++NameCounter % 4;
									break;
								}

								case 3:
								{
									try
									{
										JoinPacket = CreateJoinPacket(m_NameList[NameCounter].Name, false, (byte) HostCounter);
									}
									catch
									{
										throw new Exception("There are no custom names to refresh with. Change the name options to resume refreshing.");
									}
									NameCounter = ++NameCounter % m_NameList.Length;
									break;
								}
								case 4:
								{
									try
									{
										JoinPacket = CreateJoinPacket(m_NameList[NameCounter].Name, true, (byte) HostCounter);
									}
									catch
									{
										throw new Exception("There are no custom names to refresh with. Change the name options to resume refreshing.");
									}
									NameCounter = ++NameCounter % m_NameList.Length;
									break;
								}
								case 5:
								{
									try
									{
										JoinPacket = CreateJoinPacket(m_NameList[NameCounter].Name, m_NameList[NameCounter].Color, (byte) HostCounter);
									}
									catch
									{
										throw new Exception("There are no custom names to refresh with. Change the name options to resume refreshing.");
									}
									NameCounter = ++NameCounter % m_NameList.Length;
									break;
								}

								default:
								{
									JoinPacket = new byte[51] {
																  0xF7, 0x1E, 0x33, 0x00, (byte) HostCounter, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE4, 0x17, 0x00,
																  0x00, 0x00, 0x00, 0x7C, 0x72, 0x41, 0x75, 0x74, 0x6F, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68,
																  0x00, 0x01, 0x00, 0x02, 0x00, 0x17, 0xE0, 0x7F, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
																  0x00, 0x00, 0x00
															  };
									break;
								}
							}

							//									JoinPacket = new byte[65] {
							//																  0xF7, 0x1E, 0x41, 0x00, HostCounter[0], 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE4, 0x17, 0x00,
							//																  0x00, 0x00, 0x00, 0x7C, 0x43, 0x46, 0x46, 0x30, 0x30, 0x34, 0x32, 0x46, 0x46, 0x44, 0x6F, 0x77,
							//																  0x6E, 0x6C, 0x6F, 0x61, 0x64, 0x20, 0x4F, 0x6E, 0x6C, 0x79, 0x21, 0x21, 0x7C, 0x72, 0x00, 0x01,
							//																  0x00, 0x02, 0x00, 0x17, 0xE0, 0x7F, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
							//																  0x00
							//															  };
							
							DummyWriters[i].Write(JoinPacket);

							byte[] ResponsePacket = new byte[5];

							for(int h = 0; h < ResponsePacket.Length; h++)
							{
								ResponsePacket[h] = DummyReaders[i].ReadByte();
							}
							if(ResponsePacket[1] == 5 && ResponsePacket[2] == 8)
							{
								if(ResponsePacket[4] == 9)
									m_GameState = GameSlotState.Full;
								else if(ResponsePacket[4] == 10)
									m_GameState = GameSlotState.Started;
								else if(ResponsePacket[4] == 7)
								{
									HostCounter = ++HostCounter % 256;
									i--;
								}
								if(--NameCounter < 0)
									NameCounter = 0;
							}

							SlotsUsed += 1;
						}
						if(!SuccessfulRefresh)
						{
							SuccessfulRefresh = true;
							UpdateLog(DateTime.Now.ToString() + " - Game successfully refreshing.\r\n");
						}
					}
					finally
					{
						for(int i = 0; i < SlotsUsed; i++)
						{
							if(DummyWriters[i] != null) DummyWriters[i].Close();
							if(DummyReaders[i] != null) DummyReaders[i].Close();
							if(DummyStreams[i] != null) DummyStreams[i].Close();
							if(DummyClients[i] != null) DummyClients[i].Close();
						}
					}
				}
				catch(Exception ex)
				{
					UpdateLog(DateTime.Now.ToString() + " - Error: " + ex.Message + ".\r\n");
					SuccessfulRefresh = false;
				}
				
				if(m_GameState == GameSlotState.Started && m_RefreshRate < 30000)
					m_RefreshTimer = 30000;
				else
					m_RefreshTimer = m_RefreshRate;
				while(m_RefreshTimer > 0 && m_IsRefreshRunning)
				{
					Thread.Sleep(1000);
					m_RefreshTimer -= 1000;
				}
			}
			WriteConfigFile();
		}

		public void Shutdown()
		{
			m_IsRefreshRunning = false;
		}

		public void ClearLog()
		{
			m_LogString = "";
			UpdateLog(DateTime.Now.ToString() + " - Log cleared.\r\n");
		}
	}
}
