using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Globalization;

////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Warcraft III Autorefresh by Jason Ureta (AKA SentryIII)
// Developed using Microsoft Visual C# .NET under the Microsoft .NET Framework 1.1.
//
// DISCLAIMER: For use on Blizzard's Battle.net Service.
// The author will not be held responsible for damages incurred, including but not limited to the banning and/or disabling of your CD-key,
// any hardware or software malfunction or destruction related to the usage of this application, or any other problems that would prevent
// you from playing Warcraft III on Battle.net. If the source code is modified in any way, the author credits and this disclaimer must
// remain accessible to users.
//
////////////////////////////////////////////////////////////////////////////////////////////////////
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Blizzard Entertainment, Battle.net, and Warcraft are trademarks or registered trademarks of Blizzard Entertainment in the U.S.
// and/or other countries. Visual C# is a registered trademark of Microsoft Corporation in the U.S. and/or other countries.
// All other trademarks are the property of their respective owners.
//
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace WarcraftIIIAutoRefresh
{
	/// <summary>
	/// Summary description for CustomNameEditor.
	/// </summary>
	public class CustomNameEditor : System.Windows.Forms.Form
	{
		private System.Windows.Forms.ColorDialog clrNameColor;
		private System.Windows.Forms.ListBox lstNames;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox txtName;
		private System.Windows.Forms.Button btnColor;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.TextBox txtColor;
		private System.Windows.Forms.Button btnOK;
		private System.Windows.Forms.Button btnCancel;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Button btnNew;
		private System.Windows.Forms.Button btnDelete;

		private bool IgnoreRefresh;
		private bool IgnoreChangeIndex;
		private bool IsColorValid;
		private int PreviousIndex;

		private ArrayList NameList;

		public delegate void d_NameList(ArrayList p_NameList);
		public event d_NameList OnModifyNameList;
		
		public const string ColorFormatString = "X2";

		public CustomNameEditor(ArrayList p_NameList)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			NameList = p_NameList;
			PreviousIndex = -1;
			IgnoreChangeIndex = false;
			IgnoreRefresh = true;
			RefreshListbox();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.clrNameColor = new System.Windows.Forms.ColorDialog();
			this.lstNames = new System.Windows.Forms.ListBox();
			this.label1 = new System.Windows.Forms.Label();
			this.txtName = new System.Windows.Forms.TextBox();
			this.btnColor = new System.Windows.Forms.Button();
			this.label2 = new System.Windows.Forms.Label();
			this.txtColor = new System.Windows.Forms.TextBox();
			this.btnOK = new System.Windows.Forms.Button();
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnNew = new System.Windows.Forms.Button();
			this.btnDelete = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// lstNames
			// 
			this.lstNames.Location = new System.Drawing.Point(8, 16);
			this.lstNames.Name = "lstNames";
			this.lstNames.Size = new System.Drawing.Size(168, 238);
			this.lstNames.TabIndex = 0;
			this.lstNames.SelectedIndexChanged += new System.EventHandler(this.lstNames_SelectedIndexChanged);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(192, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(112, 23);
			this.label1.TabIndex = 1;
			this.label1.Text = "Name";
			this.label1.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// txtName
			// 
			this.txtName.Location = new System.Drawing.Point(192, 32);
			this.txtName.MaxLength = 15;
			this.txtName.Name = "txtName";
			this.txtName.Size = new System.Drawing.Size(112, 20);
			this.txtName.TabIndex = 2;
			this.txtName.Text = "";
			// 
			// btnColor
			// 
			this.btnColor.BackColor = System.Drawing.Color.Black;
			this.btnColor.Location = new System.Drawing.Point(264, 80);
			this.btnColor.Name = "btnColor";
			this.btnColor.Size = new System.Drawing.Size(40, 24);
			this.btnColor.TabIndex = 3;
			this.btnColor.Click += new System.EventHandler(this.btnColor_Click);
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(192, 56);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(112, 23);
			this.label2.TabIndex = 4;
			this.label2.Text = "Color";
			this.label2.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// txtColor
			// 
			this.txtColor.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
			this.txtColor.Location = new System.Drawing.Point(192, 80);
			this.txtColor.MaxLength = 6;
			this.txtColor.Name = "txtColor";
			this.txtColor.Size = new System.Drawing.Size(64, 20);
			this.txtColor.TabIndex = 5;
			this.txtColor.Text = "000000";
			this.txtColor.TextChanged += new System.EventHandler(this.txtColor_TextChanged);
			// 
			// btnOK
			// 
			this.btnOK.Location = new System.Drawing.Point(48, 272);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(96, 32);
			this.btnOK.TabIndex = 6;
			this.btnOK.Text = "OK";
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Location = new System.Drawing.Point(168, 272);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.Size = new System.Drawing.Size(96, 32);
			this.btnCancel.TabIndex = 6;
			this.btnCancel.Text = "Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// btnNew
			// 
			this.btnNew.Location = new System.Drawing.Point(200, 120);
			this.btnNew.Name = "btnNew";
			this.btnNew.Size = new System.Drawing.Size(96, 32);
			this.btnNew.TabIndex = 7;
			this.btnNew.Text = "New Name";
			this.btnNew.Click += new System.EventHandler(this.btnNew_Click);
			// 
			// btnDelete
			// 
			this.btnDelete.Location = new System.Drawing.Point(200, 216);
			this.btnDelete.Name = "btnDelete";
			this.btnDelete.Size = new System.Drawing.Size(96, 32);
			this.btnDelete.TabIndex = 7;
			this.btnDelete.Text = "Delete";
			this.btnDelete.Click += new System.EventHandler(this.btnDelete_Click);
			// 
			// CustomNameEditor
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(320, 318);
			this.Controls.Add(this.btnNew);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.txtColor);
			this.Controls.Add(this.txtName);
			this.Controls.Add(this.btnColor);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.lstNames);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnDelete);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "CustomNameEditor";
			this.ShowInTaskbar = false;
			this.Text = "Custom Name Editor";
			this.ResumeLayout(false);

		}
		#endregion

		private void ValidateColor()
		{
			IsColorValid = true;
			if(txtColor.Text.Length != 6)
				IsColorValid = false;
			else
			{
				foreach(char c in txtColor.Text)
					switch(c)
					{
						case '0': break;
						case '1': break;
						case '2': break;
						case '3': break;
						case '4': break;
						case '5': break;
						case '6': break;
						case '7': break;
						case '8': break;
						case '9': break;
						case 'A': break;
						case 'B': break;
						case 'C': break;
						case 'D': break;
						case 'E': break;
						case 'F': break;
						default:
						{
							IsColorValid = false;
							break;
						}
					}
			}
		}

		private void RefreshListbox()
		{
			lstNames.Items.Clear();
			for(int i = 0; i < NameList.Count; i++)
			{
				ColorName thisName = (ColorName) NameList[i];
				lstNames.Items.Add(thisName.Name);
			}
		}

		private void btnColor_Click(object sender, System.EventArgs e)
		{
			if(clrNameColor.ShowDialog(this) == DialogResult.OK)
			{
				btnColor.BackColor = clrNameColor.Color;
				txtColor.Text = clrNameColor.Color.R.ToString(ColorFormatString) +
					clrNameColor.Color.G.ToString(ColorFormatString) +
					clrNameColor.Color.B.ToString(ColorFormatString);
			}
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			lstNames.SelectedIndex = -1;
			OnModifyNameList(NameList);
			this.Close();
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void txtColor_TextChanged(object sender, System.EventArgs e)
		{
			ValidateColor();
			if(IsColorValid)
				btnColor.BackColor = ColorTranslator.FromHtml("#" + txtColor.Text);
		}

		private void lstNames_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(!IgnoreChangeIndex)
			{
				if(PreviousIndex >= 0)
				{
					if(PreviousIndex >= NameList.Count)
					{
						NameList.Add(new ColorName(txtName.Text,
							btnColor.BackColor.R.ToString(ColorFormatString) +
							btnColor.BackColor.G.ToString(ColorFormatString) +
							btnColor.BackColor.B.ToString(ColorFormatString)));
					}
					else
					{
						NameList.RemoveAt(PreviousIndex);
						NameList.Insert(PreviousIndex, new ColorName(txtName.Text,
							btnColor.BackColor.R.ToString(ColorFormatString) +
							btnColor.BackColor.G.ToString(ColorFormatString) +
							btnColor.BackColor.B.ToString(ColorFormatString)));
					}
				}
			}
			if(lstNames.SelectedIndex >= 0)
			{
				ColorName thisName = (ColorName) NameList[lstNames.SelectedIndex];
				txtName.Text = thisName.Name;
				txtColor.Text = thisName.Color;
				btnDelete.Enabled = true;
			}
			else
			{
				btnDelete.Enabled = false;
			}

			PreviousIndex = lstNames.SelectedIndex;
			if(!IgnoreRefresh)
			{
				IgnoreChangeIndex = true;
				IgnoreRefresh = true;
				RefreshListbox();
				lstNames.SelectedIndex = PreviousIndex;
				IgnoreChangeIndex = false;
				IgnoreRefresh = false;
			}
		}

		private void btnNew_Click(object sender, System.EventArgs e)
		{
			IgnoreRefresh = true;
			NameList.Add(new ColorName("NEWNAME", "ffffff"));
			RefreshListbox();
			lstNames.SelectedIndex = lstNames.Items.Count - 1;
			IgnoreRefresh = false;
		}

		private void btnDelete_Click(object sender, System.EventArgs e)
		{
			int CurrentIndex = lstNames.SelectedIndex;
			IgnoreRefresh = true;
			NameList.RemoveAt(CurrentIndex);
			RefreshListbox();
			if(CurrentIndex > lstNames.Items.Count - 1)
				CurrentIndex = lstNames.Items.Count - 1;
			IgnoreChangeIndex = true;
			lstNames.SelectedIndex = CurrentIndex;
			IgnoreChangeIndex = false;
			IgnoreRefresh = false;
		}
	}
}
