using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

using System.Threading;

////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Warcraft III Autorefresh by Jason Ureta (AKA SentryIII)
// Developed using Microsoft Visual C# .NET under the Microsoft .NET Framework 1.1.
//
// DISCLAIMER: For use on Blizzard's Battle.net Service.
// The author will not be held responsible for damages incurred, including but not limited to the banning and/or disabling of your CD-key,
// any hardware or software malfunction or destruction related to the usage of this application, or any other problems that would prevent
// you from playing Warcraft III on Battle.net. If the source code is modified in any way, the author credits and this disclaimer must
// remain accessible to users.
//
////////////////////////////////////////////////////////////////////////////////////////////////////
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Blizzard Entertainment, Battle.net, and Warcraft are trademarks or registered trademarks of Blizzard Entertainment in the U.S.
// and/or other countries. Visual C# is a registered trademark of Microsoft Corporation in the U.S. and/or other countries.
// All other trademarks are the property of their respective owners.
//
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace WarcraftIIIAutoRefresh
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class MainWindow : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.MainMenu mnuMainMenu;
		private System.Windows.Forms.MenuItem mnuFile;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem mnuFile_Exit;
		private System.Windows.Forms.MenuItem mnuHelp;
		private System.Windows.Forms.MenuItem mnuHelp_HowToUse;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem mnuHelp_About;
		private System.Windows.Forms.StatusBar statusBar;
		
		private SubSystem thisSystem;
		private Thread RefreshThread;
		private System.Windows.Forms.TextBox txtLog;
		private RefreshRateWindow RRWindow;
		private Help HelpWindow;
		private System.Windows.Forms.NumericUpDown numRefreshRate;
		private System.Windows.Forms.NumericUpDown numPortNumber;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.MenuItem mnuFile_Options;
		private System.Windows.Forms.StatusBarPanel StatusBarPanel;
		private About AboutWindow;

		public MainWindow()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			thisSystem = new SubSystem();
			thisSystem.OnUpdateLog += new WarcraftIIIAutoRefresh.SubSystem.d_UpdateLog(UpdateStatusBar);
			
			RefreshThread = new Thread(new ThreadStart(thisSystem.RefreshCycle));
			RefreshThread.Name = "Cycle Refresh Thread";
			RefreshThread.Start();

			thisSystem.InitEvent.WaitOne();
			numRefreshRate.Value = thisSystem.RefreshRate / 1000;
			if(thisSystem.PortNumber > 0)numPortNumber.Value = thisSystem.PortNumber;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(MainWindow));
			this.statusBar = new System.Windows.Forms.StatusBar();
			this.StatusBarPanel = new System.Windows.Forms.StatusBarPanel();
			this.mnuMainMenu = new System.Windows.Forms.MainMenu();
			this.mnuFile = new System.Windows.Forms.MenuItem();
			this.mnuFile_Options = new System.Windows.Forms.MenuItem();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.mnuFile_Exit = new System.Windows.Forms.MenuItem();
			this.mnuHelp = new System.Windows.Forms.MenuItem();
			this.mnuHelp_HowToUse = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.mnuHelp_About = new System.Windows.Forms.MenuItem();
			this.txtLog = new System.Windows.Forms.TextBox();
			this.numRefreshRate = new System.Windows.Forms.NumericUpDown();
			this.numPortNumber = new System.Windows.Forms.NumericUpDown();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			((System.ComponentModel.ISupportInitialize)(this.StatusBarPanel)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.numRefreshRate)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.numPortNumber)).BeginInit();
			this.SuspendLayout();
			// 
			// statusBar
			// 
			this.statusBar.Location = new System.Drawing.Point(0, 161);
			this.statusBar.Name = "statusBar";
			this.statusBar.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
																						 this.StatusBarPanel});
			this.statusBar.ShowPanels = true;
			this.statusBar.Size = new System.Drawing.Size(354, 24);
			this.statusBar.TabIndex = 11;
			// 
			// StatusBarPanel
			// 
			this.StatusBarPanel.MinWidth = 100;
			this.StatusBarPanel.Text = "gfsdfes";
			// 
			// mnuMainMenu
			// 
			this.mnuMainMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						this.mnuFile,
																						this.mnuHelp});
			// 
			// mnuFile
			// 
			this.mnuFile.Index = 0;
			this.mnuFile.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					this.mnuFile_Options,
																					this.menuItem1,
																					this.mnuFile_Exit});
			this.mnuFile.Text = "File";
			// 
			// mnuFile_Options
			// 
			this.mnuFile_Options.Index = 0;
			this.mnuFile_Options.Text = "Name Options...";
			this.mnuFile_Options.Click += new System.EventHandler(this.mnuFile_Options_Click);
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 1;
			this.menuItem1.Text = "-";
			// 
			// mnuFile_Exit
			// 
			this.mnuFile_Exit.Index = 2;
			this.mnuFile_Exit.Shortcut = System.Windows.Forms.Shortcut.AltF4;
			this.mnuFile_Exit.Text = "Exit";
			this.mnuFile_Exit.Click += new System.EventHandler(this.mnuFile_Exit_Click);
			// 
			// mnuHelp
			// 
			this.mnuHelp.Index = 1;
			this.mnuHelp.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					this.mnuHelp_HowToUse,
																					this.menuItem2,
																					this.mnuHelp_About});
			this.mnuHelp.Text = "Help";
			// 
			// mnuHelp_HowToUse
			// 
			this.mnuHelp_HowToUse.Index = 0;
			this.mnuHelp_HowToUse.Shortcut = System.Windows.Forms.Shortcut.F1;
			this.mnuHelp_HowToUse.Text = "How To Use...";
			this.mnuHelp_HowToUse.Click += new System.EventHandler(this.mnuHelp_HowToUse_Click);
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 1;
			this.menuItem2.Text = "-";
			// 
			// mnuHelp_About
			// 
			this.mnuHelp_About.Index = 2;
			this.mnuHelp_About.Text = "About Warcraft III Autorefresh...";
			this.mnuHelp_About.Click += new System.EventHandler(this.mnuHelp_About_Click);
			// 
			// txtLog
			// 
			this.txtLog.Location = new System.Drawing.Point(0, 56);
			this.txtLog.Multiline = true;
			this.txtLog.Name = "txtLog";
			this.txtLog.ReadOnly = true;
			this.txtLog.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.txtLog.Size = new System.Drawing.Size(352, 120);
			this.txtLog.TabIndex = 0;
			this.txtLog.Text = "";
			// 
			// numRefreshRate
			// 
			this.numRefreshRate.Location = new System.Drawing.Point(40, 24);
			this.numRefreshRate.Maximum = new System.Decimal(new int[] {
																		   60,
																		   0,
																		   0,
																		   0});
			this.numRefreshRate.Minimum = new System.Decimal(new int[] {
																		   5,
																		   0,
																		   0,
																		   0});
			this.numRefreshRate.Name = "numRefreshRate";
			this.numRefreshRate.Size = new System.Drawing.Size(104, 20);
			this.numRefreshRate.TabIndex = 13;
			this.numRefreshRate.Value = new System.Decimal(new int[] {
																		 15,
																		 0,
																		 0,
																		 0});
			this.numRefreshRate.ValueChanged += new System.EventHandler(this.numRefreshRate_ValueChanged);
			// 
			// numPortNumber
			// 
			this.numPortNumber.Location = new System.Drawing.Point(200, 24);
			this.numPortNumber.Maximum = new System.Decimal(new int[] {
																		  65535,
																		  0,
																		  0,
																		  0});
			this.numPortNumber.Minimum = new System.Decimal(new int[] {
																		  1,
																		  0,
																		  0,
																		  0});
			this.numPortNumber.Name = "numPortNumber";
			this.numPortNumber.Size = new System.Drawing.Size(104, 20);
			this.numPortNumber.TabIndex = 13;
			this.numPortNumber.Value = new System.Decimal(new int[] {
																		6112,
																		0,
																		0,
																		0});
			this.numPortNumber.ValueChanged += new System.EventHandler(this.numPortNumber_ValueChanged);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(40, 0);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(104, 23);
			this.label1.TabIndex = 14;
			this.label1.Text = "Refresh Rate";
			this.label1.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(200, 0);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(104, 23);
			this.label2.TabIndex = 14;
			this.label2.Text = "Port Number";
			this.label2.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// MainWindow
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(354, 185);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.numRefreshRate);
			this.Controls.Add(this.txtLog);
			this.Controls.Add(this.statusBar);
			this.Controls.Add(this.numPortNumber);
			this.Controls.Add(this.label2);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.Menu = this.mnuMainMenu;
			this.MinimumSize = new System.Drawing.Size(362, 132);
			this.Name = "MainWindow";
			this.Text = "Warcraft III Autorefresh";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.MainWindow_Closing);
			this.SizeChanged += new System.EventHandler(this.MainWindow_SizeChanged);
			((System.ComponentModel.ISupportInitialize)(this.StatusBarPanel)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.numRefreshRate)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.numPortNumber)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new MainWindow());
		}

		private void UpdateStatusBar()
		{
			StatusBarPanel.Text = thisSystem.Message;
			txtLog.Text = thisSystem.LogString;
		}

		private void mnuFile_Exit_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void MainWindow_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			thisSystem.Shutdown();
		}

		private void mnuFile_SetRefreshRate_Click(object sender, System.EventArgs e)
		{
			if(RRWindow == null)
			{
				RRWindow = new RefreshRateWindow(thisSystem.RefreshRate);
				RRWindow.OnRefreshRateChange += new WarcraftIIIAutoRefresh.RefreshRateWindow.d_UpdateRefreshRate(RRWindow_OnRefreshRateChange);
				RRWindow.Closed += new EventHandler(RRWindow_Closed);
				RRWindow.Show();
			}
			else
				RRWindow.Focus();
		}
		
		private void RRWindow_OnRefreshRateChange(int RefreshRate)
		{
			thisSystem.RefreshRate = RefreshRate;
		}

		private void mnuFile_DownloadOnly_Click(object sender, System.EventArgs e)
		{
//			mnuFile_DownloadOnly.Checked = !mnuFile_DownloadOnly.Checked;
//			thisSystem.IsDownloadOnly = mnuFile_DownloadOnly.Checked;
		}

		private void MainWindow_SizeChanged(object sender, System.EventArgs e)
		{
			txtLog.Width = this.ClientRectangle.Width;
			txtLog.Height = this.ClientRectangle.Height - txtLog.Location.Y - statusBar.Height;
			StatusBarPanel.Width = this.ClientRectangle.Width;
		}

		private void mnuHelp_HowToUse_Click(object sender, System.EventArgs e)
		{
			if(HelpWindow == null)
			{
				HelpWindow = new Help();
				HelpWindow.Show();
				HelpWindow.Closed +=new EventHandler(HelpWindow_Closed);
			}
			else
				HelpWindow.Focus();
		}

		private void mnuHelp_About_Click(object sender, System.EventArgs e)
		{
			if(AboutWindow == null)
			{
				AboutWindow = new About();
				AboutWindow.Show();
				AboutWindow.Closed += new EventHandler(AboutWindow_Closed);
			}
			else
				AboutWindow.Focus();
		}

		private void RRWindow_Closed(object sender, EventArgs e)
		{
			RRWindow = null;
		}

		private void HelpWindow_Closed(object sender, EventArgs e)
		{
			HelpWindow = null;
		}

		private void AboutWindow_Closed(object sender, EventArgs e)
		{
			AboutWindow = null;
		}

		private void numRefreshRate_ValueChanged(object sender, System.EventArgs e)
		{
			thisSystem.RefreshRate = (int) numRefreshRate.Value;
		}

		private void numPortNumber_ValueChanged(object sender, System.EventArgs e)
		{
			thisSystem.PortNumber = (int) numPortNumber.Value;
		}

		private void mnuFile_Options_Click(object sender, System.EventArgs e)
		{
			ArrayList thisList = new ArrayList(thisSystem.NameList);
			NameWindow thisWindow = new NameWindow(thisList);
			thisWindow.OnModifyNameList += new WarcraftIIIAutoRefresh.NameWindow.d_NameList(thisWindow_OnModifyNameList);
			thisWindow.OnModifyOption += new WarcraftIIIAutoRefresh.NameWindow.d_Option(thisWindow_OnModifyOption);
			thisWindow.NameOption = thisSystem.NameOption;
			thisWindow.ShowDialog();
		}

		private void thisWindow_OnModifyNameList(ArrayList p_NameList)
		{
			ColorName temp = new ColorName("", "");
			thisSystem.NameList = (ColorName[]) p_NameList.ToArray(Type.GetTypeFromHandle(Type.GetTypeHandle(temp)));
		}

		private void thisWindow_OnModifyOption(int p_Option)
		{
			thisSystem.NameOption = p_Option;
		}
	}
}
