using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Warcraft III Autorefresh by Jason Ureta (AKA SentryIII)
// Developed using Microsoft Visual C# .NET under the Microsoft .NET Framework 1.1.
//
// DISCLAIMER: For use on Blizzard's Battle.net Service.
// The author will not be held responsible for damages incurred, including but not limited to the banning and/or disabling of your CD-key,
// any hardware or software malfunction or destruction related to the usage of this application, or any other problems that would prevent
// you from playing Warcraft III on Battle.net. If the source code is modified in any way, the author credits and this disclaimer must
// remain accessible to users.
//
////////////////////////////////////////////////////////////////////////////////////////////////////
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Blizzard Entertainment, Battle.net, and Warcraft are trademarks or registered trademarks of Blizzard Entertainment in the U.S.
// and/or other countries. Visual C# is a registered trademark of Microsoft Corporation in the U.S. and/or other countries.
// All other trademarks are the property of their respective owners.
//
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace WarcraftIIIAutoRefresh
{
	/// <summary>
	/// Summary description for RefreshRateWindow.
	/// </summary>
	public class RefreshRateWindow : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.NumericUpDown numRefreshRate;
		private System.Windows.Forms.Button btnOk;
		private System.Windows.Forms.Button btnCancel;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public delegate void d_UpdateRefreshRate(int RefreshRate);
		public event d_UpdateRefreshRate OnRefreshRateChange;


		public RefreshRateWindow(int RefreshRate)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			try { numRefreshRate.Value = RefreshRate / 1000; }
			catch { numRefreshRate.Value = 15; }
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.numRefreshRate = new System.Windows.Forms.NumericUpDown();
			this.btnOk = new System.Windows.Forms.Button();
			this.btnCancel = new System.Windows.Forms.Button();
			((System.ComponentModel.ISupportInitialize)(this.numRefreshRate)).BeginInit();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(72, 32);
			this.label1.TabIndex = 0;
			this.label1.Text = "Refresh Rate (sec)";
			this.label1.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// numRefreshRate
			// 
			this.numRefreshRate.Location = new System.Drawing.Point(88, 8);
			this.numRefreshRate.Maximum = new System.Decimal(new int[] {
																		   60,
																		   0,
																		   0,
																		   0});
			this.numRefreshRate.Minimum = new System.Decimal(new int[] {
																		   5,
																		   0,
																		   0,
																		   0});
			this.numRefreshRate.Name = "numRefreshRate";
			this.numRefreshRate.Size = new System.Drawing.Size(48, 20);
			this.numRefreshRate.TabIndex = 1;
			this.numRefreshRate.Value = new System.Decimal(new int[] {
																		 15,
																		 0,
																		 0,
																		 0});
			// 
			// btnOk
			// 
			this.btnOk.Location = new System.Drawing.Point(8, 48);
			this.btnOk.Name = "btnOk";
			this.btnOk.Size = new System.Drawing.Size(64, 23);
			this.btnOk.TabIndex = 2;
			this.btnOk.Text = "&Okay";
			this.btnOk.Click += new System.EventHandler(this.btnOk_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(80, 48);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.Size = new System.Drawing.Size(64, 23);
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// RefreshRateWindow
			// 
			this.AcceptButton = this.btnOk;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(154, 88);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOk);
			this.Controls.Add(this.numRefreshRate);
			this.Controls.Add(this.label1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "RefreshRateWindow";
			this.ShowInTaskbar = false;
			this.Text = "Set Refresh Rate";
			((System.ComponentModel.ISupportInitialize)(this.numRefreshRate)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		private void btnOk_Click(object sender, System.EventArgs e)
		{
			OnRefreshRateChange((int) numRefreshRate.Value);
			this.Close();
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}
	}
}
