------------------------------------------------------------------------------------------------
-- Starcraft 2 Model Objects version 0.05
-- by NiNtoxicated (madyavic@gmail.com)
-- 3ds max objects for use with Starcraft 2 model files (.M3)
-- Created for 3ds max 2010, but should be backwards compatible
--
-- Objects:
-- sc2material - Material plugin for setting material and layer properties
-- sc2bitmap - Bitmap plugin with extra map options
-- sc2attachment - Helper plugin to add attachments to a scene
--
-- User Interfaces:
-- sc2animUI - Animation interface for viewing and editing animations
--
------------------------------------------------------------------------------------------------
--
-- Version History:
-- 0.05b - July 22nd 2010
-- Attachments now retain previous settings
-- Added two new attachment ID presets
--
-- 0.05 - July 15th 2010
-- Added sc2bitmap custom map support
-- Added sc2bitmap brightness multiplier
-- Added to sc2bitmap more UV options
--
-- 0.04b - June 29th 2010
-- Fixed Start frame minusing by 1 bug in animation UI
--
-- 0.04 - June 28th 2010
-- Added attachment custom object
-- Updated material, now supports Terrain (Null) textures
-- Updated decal entry in material, now supports decals properly
-- Updated bitmap to support map channels
-- Fixed same range animation UI error
--
-- 0.03b - June 12th 2010
-- Fixed Animation data holder not being updated correctly
--
-- 0.03 - June 9th 2010
-- Updated Animation UI heavily to include editing capabilities
-- Added callback support for Animation UI
-- Added view button to sc2bitmap materials
--
-- 0.02 - May 17th 2010
-- sc2bitmap definition updated
-- Integrated animation UI
--
-- 0,01 - May 15th 2010
-- Initial objects script version
-- sc2material defined
-- sc2bitmap defined
--
------------------------------------------------------------------------------------------------
-- *****************
--  MISC GLOBALS
-- *****************
global SC2PLUGIN_VERS = 0.05

-- ***********************
--  GLOBAL FUNCTIONS
-- ***********************
fn sc2uiOpenFile ftypes &fname =
(
	local ret 
	if (fname != undefined) then
	(
		ret = getOpenFileName types:ftypes filename:fname
	)
	else
	(
		ret = getOpenFileName types:ftypes
	)
	if ret != undefined then fname = ret
)

-- ***************
--  M3 OBJECTS
-- *************** 
plugin Material sc2material
name:"Starcraft 2" 
classID:#(0x1ccf0cb1, 0x1e0c2826)
extends:Standard replaceUI:true version:2
( 
	local mattypeui, matsettui, flagsui, layersui
	local isCreated = false
	
	parameters matsett rollout:matsettui
	(
		blendMode type:#integer default:1 ui:ddlBlendMode
		priority type:#integer default:0 ui:spnPriority
		cutoutThresh type:#integer default:0 ui:spnCutoutThresh
		specVal type:#float default:0 ui:spnSpec
		specMult type:#float default:1 ui:spnSpecMult
		emisMult type:#float default:1 ui:spnEmisMult
		layerBlendType type:#integer default:3 ui:ddlLayerBlend
		emissiveBlendType type:#integer default:3 ui:ddlEmissiveBlend
			
		on specVal set val do delegate.specularLevel = val
	)
	
	parameters flags rollout:flagsui
	(
		Unfogged type:#boolean ui:chkUnfogged
		TwoSided type:#boolean ui:chkTwoSided
		Unshaded type:#boolean ui:chkUnshaded
		NoHitTest type:#boolean ui:chkNoHitTest
		DepthPrepass type:#boolean ui:chkDepthPrepass
		UseTerrainHDR type:#boolean ui:chkTerrainHDR
		SplatUVfix type:#boolean ui:chkSplatUV
		SoftBlending type:#boolean ui:chkSoftBlend
		NoShadowsCast type:#boolean ui:chkNoShadowsCast
		NoShadowsReceived type:#boolean ui:chkNoShadowsRec
		
		on TwoSided set val do delegate.twoSided = val
	)
	
	parameters layers rollout:layersui
	(
		compMap type:#textureMap
		diffuseMap type:#textureMap ui:mbDiffuse
		decalMap type:#textureMap ui:mbDecal
		specularMap type:#textureMap ui:mbSpec
		selfIllumMap type:#textureMap ui:mbEmis
		emisMap2 type:#textureMap ui:mbEmis2
		envioMap type:#textureMap ui:mbEnvio
		envioMaskMap type:#textureMap ui:mbEnvioMask
		alphaMaskMap type:#textureMap ui:mbAlphaMask
		bumpMap type:#textureMap ui:mbNorm
		heightMap type:#textureMap ui:mbHeight

		-- Set Maps
		on diffuseMap set val do 
		(
			compMap.mapList[1] = val
		)
		on decalMap set val do
		(
			local dmap = val
			if (dmap != undefined) then 
			(
				local dmapClass = classOf dmap as string
				if (dmapClass == "sc2bitmap") then
				(
					dmap.isDecal = true
					dmap.preMultAlpha = false
				)
			)
			compMap.mapList[2] = dmap
		)
		on compMap set val do
		(
			delegate.diffuseMap = val
		)
		on specularMap set val do delegate.specularMap = val
		on selfIllumMap set val do delegate.selfIllumMap = val
		on bumpMap set val do delegate.bumpMap = val
		--on envioMap set val do delegate.ReflectionMap = val
	)
	
	parameters mattype rollout:mattypeui
	(
		materialType type:#integer default:2 ui:ddlMaterialType
		
		on materialType set val do
		(
			if (this.isCreated == true) then
			(
				case val of
				(
					1: 
					(
						removeRollout this.matsettui
						removeRollout this.layersui
						removeRollout this.flagsui
						
						-- blank maps
						this.diffuseMap 		= undefined
						this.decalMap 			= undefined
						this.specularMap 		= undefined
						this.selfIllumMap 		= undefined
						this.emisMap2			= undefined
						this.envioMap 			= undefined
						this.envioMaskMap	= undefined
						this.alphaMaskMap	= undefined
						this.bumpMap			= undefined
						this.heightMap			= undefined
					)
					2: 
					(
						addRollout this.matsettui
						addRollout this.layersui
						addRollout this.flagsui
					)
				)
			)
		)
	)
	
	rollout matsettui "Material Settings" category:2
	(
		group "Blend Types"
		(
			dropdownlist ddlBlendMode "Blend Mode:" items:#("Opaque", "Alpha Blend", "Add", "Alpha Add",  "Mod", "Mod 2x") across:2 align:#left width:85 across:2
			dropdownlist ddlLayerBlend "Layer Blend Type:" items:#("Mod", "Mod 2x", "Add", "Blend", "Team Colour Emissive Add", "Team Colour Diffuse Add") selection:3 align:#left width:120 
			dropdownlist ddlEmissiveBlend "Emissive Blend Type:" items:#("Mod", "Mod 2x", "Add", "Blend", "Team Colour Emissive Add", "Team Colour Diffuse Add") selection:3 align:#left width:120 
		)

		group "Properties"
		(
			spinner spnPriority "Priority: " fieldwidth:40 range:[0,1e9,0] type:#integer align:#left across:2
			spinner spnCutoutThresh "Cutout Threshold: " fieldwidth:40 range:[0,1e9,0] type:#integer scale:1 
			spinner spnSpec "Specularity: " fieldwidth:45 range:[0,1e9,0] scale:1 align:#left across:2
			spinner spnEmisMult "HDR Emissive Multiplier: " fieldwidth:45 range:[0,1e9,1] scale:1 align:#right
			spinner spnSpecMult "HDR Specular Multiplier: " fieldwidth:45 range:[0,1e9,1] scale:1 align:#right 
		)
		
		on matsettui open do
		(
			case materialType of
			(
				1: removeRollout this.matsettui
			)
		)
	)
	
	rollout flagsui "Flags" category:4
	(
		group "Flags"
		(
			checkbox chkUnfogged "Unfogged" align:#left across:3
			checkbox chkTwoSided "Two Sided"
			checkbox chkUnshaded "Unshaded"
			
			checkbox chkNoHitTest "No Hit Test" align:#left across:3
			checkbox chkDepthPrepass "Depth Pre-pass"
			checkbox chkTerrainHDr "Use Terrain HDR" 
			
			checkbox chkSplatUV "Splat UV Fix" align:#left across:3
			checkbox chkSoftBlend "Soft Blending"			
			checkbox chkNoShadowsCast "No Shadows Cast"
			
			checkbox chkNoShadowsRec "No Shadows Received"
		)
		
		on flagsui open do
		(
			case materialType of
			(
				1: removeRollout this.flagsui
			)			
		)
	)
	
	rollout layersui "Layers" category:3
	(
		group "Map Layers"
		(
			label lblDiffuse "Diffuse Map: " across:2 align:#left
			mapbutton mbDiffuse "None" tooltip:"Select Diffuse Map" offset:[-45,0] width:175
			label lblDecal "Decal Map: " across:2 align:#left
			mapbutton mbDecal "None" tooltip:"Select Decal Map" offset:[-45,0] width:175
			label lblSpec "Specular Map: " across:2 align:#left
			mapbutton mbSpec "None" tooltip:"Select Specular Map" offset:[-45,0] width:175
			label lblEmis "Emissive Map: " across:2 align:#left
			mapbutton mbEmis "None" tooltip:"Select Emissive Map" offset:[-45,0] width:175
			label lblEmis2 "Emissive Map 2: " across:2 align:#left
			mapbutton mbEmis2 "None" tooltip:"Select Emissive Map" offset:[-45,0] width:175
			label lblEnvio "Envio Map: " across:2 align:#left
			mapbutton mbEnvio "None" tooltip:"Select Envio Map" offset:[-45,0] width:175
			label lblEnvioMask "Envio Mask Map: " across:2 align:#left
			mapbutton mbEnvioMask "None" tooltip:"Select Envio Mask Map" offset:[-45,0] width:175
			label lblAlphaMask "Alpha Mask Map: " across:2 align:#left
			mapbutton mbAlphaMask "None" tooltip:"Select Alpha Mask Map" offset:[-45,0] width:175
			label lblNorm "Normal Map: " across:2 align:#left
			mapbutton mbNorm "None" tooltip:"Select Normal Map" offset:[-45,0] width:175
			label lblHeight "Height Map: " across:2 align:#left
			mapbutton mbHeight "None" tooltip:"Select Height Map" offset:[-45,0] width:175
		)
		
		on layersui open do
		(
			case materialType of
			(
				1: removeRollout this.layersui
			)
		)
	)

	rollout mattypeui "Material Type" category:1
	(
		dropdownlist ddlMaterialType "Material Type:" items:#("Terrain (Null)", "Normal") width:120
		
		on mattypeui open do
		(
			-- necessary for proper add/remove rollout in plugin
			if this.isCreated == false then 
			(
				this.isCreated = true
			)
		)
	)
	
	on create do
	(
		-- setup initial material
		delegate.bumpMapAmount = 100
		
		-- initialise composite
		compMap = compositeTextureMap()
		compMap.mapList.count = 2
	)
	
	on update do
	(
		if version == 1 then
		(
			this.compMap = compositeTextureMap()
			this.compMap.mapList.count = 2
			if (delegate.diffuseMap != undefined) then
			(
				local classMap = classOf delegate.diffuseMap as string
				if (classMap != "CompositeTexturemap") then 
				(
					this.compMap.mapList[1] = diffuseMap
					this.compMap.mapList[2] = decalMap
					delegate.diffuseMap = compMap
				)
			)
			this.isCreated = false
			this.materialType = 2
		)
	)
)

plugin textureMap sc2bitmap
name:"Starcraft 2 Bitmap"
classID:#(0x48f387a2, 0x6950179f)
autoPromoteDelegateProps:true
extends:Bitmaptexture replaceUI:true version:5
remap:#(#("TexWrap"),#("TexWrap2"))
(
	local isCreated = false
	
	fn assign_bitmap =
	(
		local bmap = SelectBitmap()
		if (bmap != undefined) then
		(
			-- update bitmap
			delegate.bitmap = bmap
		)
		else
		(
			-- else leave it as it was if no custom map detected
			if (this.scCustomMap.count < 1) then
			(
				bmap = this.scbitmap
			)
		)
		return bmap
	)
	
	parameters map rollout:mapui
	(
		scbitmap type:#bitmap
		scCustomMap type:#string default:""
		isDecal type:#boolean default:false
		
		on scbitmap set val do
		(
			if (scbitmap != undefined) then
			(
				local scbitmapClass = classOf scbitmap as string
				if (scbitmapClass == "BitMap") then
				(
					if (scbitmap.filename.count > 0) then
					(
						delegate.bitmap = scbitmap
						if (isDecal == true) then delegate.preMultAlpha = false
					)
					else
					(
						delegate.bitmap.filename = ""
					)
				)
			)
		)
	)--end params
	
	parameters mapsett rollout:mapsettui
	(
		-- General Settings
		Bright_Mult type:#float default:1.0 ui:spnBright_Mult
		
		-- Coordinate Settings
		mapChannel type:#integer default:1 ui:spnMapChannel
		U_Tiling type:#float default:1.0 ui:spnU_Tiling
		V_Tiling type:#float default:1.0 ui:spnV_Tiling
		U_Tile type:#boolean default:true ui:chkU_Tile
		V_Tile type:#boolean default:true ui:chkV_Tile
		
		on mapChannel set val do
		(
			delegate.coords.mapChannel = val
		)
		on U_Tile set val do delegate.coords.U_Tile = val
		on V_Tile set val do delegate.coords.V_Tile = val
		on U_Tiling set val do delegate.coords.U_Tiling = val
		on V_Tiling set val do delegate.coords.V_Tiling = val
	)
	
	parameters alphasett rollout:alphasettui
	(
		-- Alpha Flags
		TeamColour type:#boolean ui:chkTeamColour
		TexAlphaOnly type:#boolean ui:chkTexAlphaOnly
	)

	rollout mapui "Map Path"
	(
		local mapSet
		
		group "Map"
		(
			label	lblBitmap "Bitmap:" align:#left across:2
			button btnBitmap "None" offset:[-55,0] width:260 text:"None"
			button btnViewImage "View Image" align:#right enabled:false
		)
		
		rollout mapPick "Map Type"
		(
			group "Bitmap Type"
			(
				radiobuttons mapType labels:#("3ds Max Bitmap", "Custom Bitmap")
			)
			label lblNote "Note:" align:#left
			label lblNoteDesc "Custom maps won't render in max!" align:#left height:30
			
			button bOK "OK" across:2
			button bCancel "Cancel"
			
			on bOK pressed do
			(
				case mapType.state of
				(
					1:	mapui.mapSet = #maxmap
					2: mapui.mapSet = #custom
				)
				
				Destroydialog mapPick
			)
			on bCancel pressed do
			(
				mapui.mapSet = undefined
				Destroydialog mapPick
			)
		)
	
		on mapui open do
		(
			if (scCustomMap.count > 0) then
			(
				btnBitmap.text = scCustomMap
				btnViewImage.enabled = false
			)
			else
			(
				if (scbitmap != undefined) then
				(
					btnBitmap.text = scbitmap.filename
					btnViewImage.enabled = true
				)
				else btnBitmap.text = "None"
			)
		)
		on btnBitmap pressed do
		(
			local newPos = mouse.screenpos
			newPos.x -= 85
			newPos.y -= 95
			if (createDialog mapPick modal:true pos:newPos width:185) then
			(
				case mapui.mapSet of
				(
					#maxmap:
					(
						local map = assign_bitmap()
						if (map != undefined) then
						(
							this.scbitmap = map
							this.scCustomMap = ""
							btnBitmap.text = this.scbitmap.filename
							btnViewImage.enabled = true
						)
					)
					#custom: 
					(
						sc2uiOpenFile "OGV Movie Files (*.ogv)|*.ogv|All Files|*.*|" &scCustomMap
						if (scCustomMap.count > 0) then 
						(
							if (this.scbitmap != undefined) then 
							(
								local tBitMap 
								--tBitMap.filename = ""
								--this.scbitmap = tBitMap
								delegate.filename = ""
							)
							btnBitmap.text = scCustomMap
							btnViewImage.enabled = false
						)
					)
				)
			)
		)
		on btnViewImage pressed do
		(
			if (scbitmap != undefined) then
			(
				display scbitmap
			)
		)
		on mapui reload do
		(
			if (scCustomMap.count > 0) then
			(
				btnBitmap.text = scCustomMap
				btnViewImage.enabled = false
			)
			else
			(
				if (scbitmap != undefined) then
				(
					btnBitmap.text = scbitmap.filename
					btnViewImage.enabled = true
				)
				else btnBitmap.text = "None"
			)
		)
	)--end rollout
	
	rollout mapsettui "Map Settings"
	(
		group "General Properties"
		(
			spinner spnBright_Mult "Brightness Multiplier" default:1.0 scale:0.1 width:85 align:#left
		)
		
		group "UV Coordinates"
		(
			label lblTiling "Tiling" align:#left offset:[30,0] across:3 
			label lblTile "Tile" align:#left offset:[-12,0]
			spinner spnMapChannel "Map Channel:" type:#integer fieldWidth:45 align:#left range:[1,100,1] across:2 enabled:false offset:[-30,0]
			spinner spnU_Tiling "U:" across:2 default:1.0 scale:0.1 width:80 align:#left
			checkbox chkU_Tile "" checked:true align:#left offset:[-60,0]
			spinner spnV_Tiling "V:" across:2 default:1.0 scale:0.1 width:80 align:#left
			checkbox chkV_Tile "" checked:true align:#left offset:[-60,0]
		)
		
		fn set_decal =
		(
			if (this.isDecal == true) then
			(
				if (this.isCreated != true) then
				(
					this.mapChannel = 2
					--this.TexWrap = false
					this.TeamColour = true
					this.isCreated = true
				)
				spnMapChannel.enabled = true
			)
		)
		
		on mapsettui open do
		(
			set_decal()
		)
		on mapsettui reload do
		(
			set_decal()
		)
	)
	
	rollout alphasettui "Alpha Settings"
	(
		group "Alpha Flags"
		(
			checkbox chkTeamColour "Render Alpha as Team Colour" align:#left across:2
			checkbox chkTexAlphaOnly "Render Alpha Only" checked:false align:#right
		)	
		
		on chkTexAlphaOnly changed state do
		(
			if (state == false) then
			(
				chkTeamColour.enabled = true
			)
			else
			(
				chkTeamColour.checked = false
				chkTeamColour.enabled = false
			)
		)
		on mapsettui open do
		(
			if (chkTexAlphaOnly.checked == true) then
			(
				chkTeamColour.checked = false
				chkTeamColour.enabled = false
			)
		)
		on mapsettui reload do
		(
			if (chkTexAlphaOnly.checked == true) then
			(
				chkTeamColour.checked = false
				chkTeamColour.enabled = false
			)			
		)		
	)
	
	on create do
	(
		if (this.isDecal == true) then
		(
			this.mapChannel = 2
			--this.TexWrap = false
			this.TeamColour = true
		)
	)
	
	on update do
	(
		if (version < 4) then
		(
			this.isCreated = false
			this.isDecal = false
			this.mapChannel = 1
		)
		
		if (version < 5) then
		(
			if (delegate.coords.U_Tile == true) then this.U_Tile = true else this.U_Tile = false
			if (delegate.coords.V_Tile == true) then this.V_Tile = true else this.V_Tile = false
			
			if (delegate.bitmap != undefined) then
			(
				this.scbitmap = delegate.bitmap
			)
		)
	)
)--end plugin

global sc2att_size = 0.08
global sc2att_id = ""

plugin Helper sc2attachment
name:"Attachment"
classID:#(0x2e993b39, 0x43824ff0)
category:"Starcraft 2 Objects"
extends:Dummy
version:2
(
	local AttachIDlist = #("Custom", "Ref_Center", "Ref_Damage", "Ref_Hardpoint", "Ref_Head", "Ref_Origin", "Ref_Overhead", "Ref_Target", "Ref_Weapon", "Ref_Weapon Left", "Ref_Weapon Right")
	
	fn getOwners =
	(
		for o in refs.dependents this where isValidNode o collect o
	)
	
	parameters main rollout:mainui
	(
		boxSize type:#float ui:spnBoxSize
		
		on boxSize set val do
		(
			delegate.boxsize = [val,val,val]
			sc2att_size = val
		)
	)
	
	parameters attachsett rollout:attachsettui
	(
		attachID type:#integer ui:ddlAttachID
		attachName type:#string ui:edtAttachID
		
		on attachID set val do
		(
			if (val > 1) then
			(
				attachName = AttachIDlist[val]
			)
		)
		on attachName set val do
		(
			if (val != "" and val != undefined) then
			(
				local attInd = findItem AttachIDlist val
				if (attInd < 2) then 
				(
					attachID = 1 
				)
				else 
				(
					attachID = attInd
				)
				sc2att_id = val
			)
			else
			(
				attachID = 1
			)
		)
	)
	
	rollout mainui "Main Parameters"
	(
		spinner spnBoxSize "Box Size:" range:[0, 1e9, sc2att_size] type:#float scale:0.01
	)
	
	rollout attachsettui "Attachment Parameters"
	(
		group "Select Attachment ID"
		(
			dropdownlist ddlAttachID items:AttachIDlist
		)
		edittext edtAttachID "Attachment ID:" labelOnTop:true
		
		on ddlAttachID selected i do
		(
			if (i > 1) then
			(
				edtAttachID.text = ddlAttachID.selected
			)
		)
		on edtAttachID entered val do
		(
			local attInd = findItem AttachIDlist val
			if (attInd < 2) then ddlAttachID.selection = 1 else ddlAttachID.selection = attInd
		)
		on params open do
		(
			if (edtAttachID.text != "" and edtAttachID.text != undefined) then
			(
				local attInd = findItem AttachIDlist edtAttachID.text
				if (attInd < 2) then ddlAttachID.selection = 1 else ddlAttachID.selection = attInd
			)
		)
	)
	
	on create do
	(
		boxSize = sc2att_size
		attachName = sc2att_id
	)

	tool create 
	( 
		on mousePoint click do 
		(
			if click == 1 then 
			(
				nodeTM.translation = gridPoint
				delegate.boxsize = [boxSize, boxSize, boxSize]
			)
			else #stop
		)
	) 
)


-- ********************
--  M3 UI ELEMENTS
-- ********************
-- Animation UI dependents
struct sc2anim
(
	-- Default values incase not found
	name = "Stand", seqInd = 0, 
	cstart = 0, cend = 1000, 
	freq = 100, moveSpeed = 0, looping = false
)

fn sc2_AnimToStrm anim =
(
	local ss = stringStream ""
	format ".name:%\n" anim.name to:ss
	format ".seqInd:%\n" anim.seqInd to:ss
	format ".cstart:%\n" anim.cstart to:ss
	format ".cend:%\n" anim.cend to:ss
	format ".freq:%\n" anim.freq to:ss
	format ".moveSpeed:%\n" anim.moveSpeed to:ss
	format ".looping:%\n" anim.looping to:ss
	return ss
)

fn sc2_Set_Scene_Data obj animdata =
(
	local aheader = stringstream ""
	format ".version:%\n" SC2PLUGIN_VERS to:aheader
	format ".count:%\n" animdata.count to:aheader
	setAppData obj 1 aheader
	for i = 1 to animdata.count do
	(
		local aind = i + 1
		local ad = animdata[i]
		
		local adss = sc2_AnimToStrm ad
		setAppData obj aind adss
	)
)

fn sc2_Get_ssData stringStrm property type:#value =
(
	-- reposition at start of stream
	seek stringStrm 0
	if (skipToString stringStrm property != undefined) then
	(
		local val
		case type of
		(
			#string: val = readLine stringStrm
			#value: val = readValue stringStrm
			#boolean: val = readValue stringStrm as booleanClass
		)

		return val
	)
)

fn sc2_Get_AnimData animss sc2Vers =
(
	local anim = sc2anim()
	
	anim.name 		= sc2_Get_ssData animss ".name:" type:#string
	anim.seqInd	= sc2_Get_ssData animss ".seqInd:"
	anim.cstart 	= sc2_Get_ssData animss ".cstart:"
	anim.cend 		= sc2_Get_ssData animss ".cend:"
	if (sc2vers != undefined) then
	(
		case of
		(
			default:
			(
				anim.freq		= sc2_Get_ssData animss ".freq:"
				anim.moveSpeed = sc2_Get_ssData animss ".moveSpeed:"
				anim.looping	= sc2_Get_ssData animss ".looping:" type:#boolean
			)
		)
	)
	else
	(
		anim.freq			= 100
		anim.moveSpeed 	= 0.0
		anim.looping		= false
	)
	
	return anim
)

-- Animation UI
utility sc2animUI "M3 - Sequences"
(
	local animList = #("None")
	local aobj = $_M3_Anim_Data
	local adata = #()
	
	Group "Select Animation"
	(
		dropdownlist	dlAnim items:#("None")
	)
	
	Group "Edit"
	(
		edittext		edtAnimName "Animation Name:" labelOnTop:true enabled:false
		spinner			spnSeqInd "Sequence Index:" range:[0,1e9,0] type:#integer width:125 align:#right enabled:false
		label				lblAnimRange "Animation Ranges" align:#left offset:[0,10]
		spinner			spnStart "Time Start:" range:[0,1e9,0] type:#integer enabled:false
		spinner			spnEnd "Time End:" range:[0,1e9,0] type:#integer enabled:false
		spinner			spnFreq "Frequency (%):" range:[0,100,100] type:#integer enabled:false fieldwidth:50
		spinner			spnMoveSpeed "Move Speed:" range:[0,1e6,0] type:#float enabled:false scale:1
		checkbox		chkLooping "Looping" align:#right enabled:false
		label				lblSpacer1 height:5
		button btnAdd "Add" align:#left across:2 width:60
		button btnRemove "Remove" align:#right enabled:false
	)
	
	fn NoneSelected =
	(
		if (adata.count > 0) then 
		(
			local lastFrame = 0
			for i = 1 to adata.count do
			(
				local ad = adata[i]
				if ad.cend > lastFrame then lastFrame = ad.cend
			)
			animationRange = interval 0 lastFrame
			spnEnd.value = lastFrame
		)
		else 
		(
			animationRange = interval 0 1000
			spnEnd.value = 1000
		)
		spnStart.value = 0
		
		-- Reset and disable UI elements
		edtAnimName.text = ""
		edtAnimName.enabled = false
		spnSeqInd.value = 0
		spnSeqInd.enabled = false
		spnStart.enabled = false
		spnEnd.enabled = false
		spnFreq.enabled = false
		spnMoveSpeed.enabled = false
		chkLooping.checked = false
		chkLooping.enabled = false
		btnRemove.enabled = false
	)
	
	fn Selected sel =
	(
		dlAnim.selection = sel

		if sel == 1 then 
		(
			NoneSelected()
		)
		else
		(
			local ad = adata[sel-1]
			animationRange = interval ad.cstart ad.cend
			sliderTime = ad.cstart
			edtAnimName.text = ad.name
			spnSeqInd.value = ad.seqInd
			spnStart.value = ad.cstart
			spnEnd.value = ad.cend
			spnFreq.value = ad.freq
			spnMoveSpeed.value = ad.moveSpeed
			chkLooping.checked = ad.looping
			
			-- Enable UI elements
			edtAnimName.enabled = true
			spnSeqInd.enabled = true
			spnStart.enabled = true
			spnEnd.enabled = true
			spnFreq.enabled = true
			spnMoveSpeed.enabled = true			
			chkLooping.enabled = true
			btnRemove.enabled = true
		)
	)
	
	fn List_Repop  =
	(
		animList = dlAnim.items
		animList = #("None")
		for i = 1 to adata.count do
		(
			ad = adata[i]
			--echo (anim_data[i].name)
			local aname = ad.name + ("["+ad.seqInd as string+"]")
			append animList aname
		)
		
		dlAnim.items = animList
	)
	
	fn List_Pop =
	(
		if (aobj != undefined and isValidNode aobj == true) then
		(	
			--reset vars
			adata = #()
			
			local acss = (getAppData aobj 1) as stringstream
			local sc2Vers = sc2_Get_ssData acss ".version:"
			local animCount = sc2_Get_ssData acss ".count:"
			if (animCount != 0) then
			(
				adata[animCount] = 0
				for h = 1 to animCount do
				(
					local stcInd = h + 1
					local stcss = (getAppData aobj stcInd) as stringstream
					local anim = sc2_Get_AnimData stcss sc2Vers
					
					-- Update with new version data
					local animss = sc2_AnimToStrm anim
					
					setAppData aobj stcInd animss
					
					adata[h] = anim
				)
			)
			
			-- Update animation storage to current version
			-- (AppData) Update Animation Count
			local adss = stringstream ""
			format ".version:%\n" SC2PLUGIN_VERS to:adss
			format ".count:%\n" adata.count to:adss
			setAppData aobj 1 adss
			
			List_Repop()
		)
	)
	
	fn UpdateEntry val entryid =
	(
		-- sanity check
		local aind = dlAnim.selection - 1
		if (aind > 0) then
		(
			-- grab AD
			local ad = adata[aind]
			objInd = aind + 1 -- obj index for replacing user data
			
			-- Set new value
			case entryid of
			(
				#name: ad.name = val
				#seqInd: ad.seqInd = val
				#cstart: ad.cstart = val
				#cend: ad.cend = val
				#freq: ad.freq = val
				#moveSpeed: ad.moveSpeed = val
				#looping: ad.looping = val
			)
			
			if (entryid == #cstart or entryid == #cend) then animationRange = interval ad.cstart ad.cend
			
			local adss = sc2_AnimToStrm ad
			-- Update app data
			setAppData aobj objInd adss
			
			-- Update UI data container
			adata[aind] = ad
			List_Repop() -- Refresh UI
		)
	)
	
	on sc2animUI open do
	(
		List_Pop()
		if (adata.count > 0) then
		(
			local rsel = random 1 adata.count
			dlAnim.selection = rsel + 1
			Selected dlAnim.selection
		)
	)
	on dlAnim selected i do
	(
		if (adata.count > 0) then
		(
			if (i == 1) then
			(
				NoneSelected()
			)
			else
			(
				Selected i
			)
		)
	)
	-- UI value updates
	on edtAnimName entered txt do (UpdateEntry txt #name)
	on spnSeqInd changed val do (UpdateEntry val #seqInd)
	on spnStart changed val do 
	(
		local nval
		if (val != spnEnd.value) then
		(
			nval = val
		)
		else
		(
			nval = val - 1
		)		
		UpdateEntry nval #cstart
		spnStart.value = nval
	)
	on spnEnd changed val do 
	(
		local nval
		if (val != spnStart.value) then
		(
			nval = val
		)
		else
		(
			nval = val + 1
		)
		UpdateEntry nval #cend
		spnEnd.value = nval
	)
	on spnFreq changed val do (UpdateEntry val #freq)
	on spnMoveSpeed changed val do (UpdateEntry val #moveSpeed)
	on chkLooping changed val do (UpdateEntry val #looping)
	on btnAdd pressed do
	(
		-- Create new animation data placeholder
		ad = sc2anim()
		if (adata.count > 0) then
		(
			ad.seqInd	= (adata[adata.count].seqInd) + 1
			ad.cstart 	= (adata[adata.count].cend as integer) + 1000
			ad.cend		= (ad.cstart as integer) + 1000
			ad.freq		= 100
			ad.moveSpeed = 0
			ad.looping = false
		)
		
		-- Append to UI animation data collection
		append adata ad

		if (isValidNode aobj != true) then
		(
			-- Initiate Scene Object
			if ($_M3_Anim_Data != undefined) then delete($_M3_Anim_Data)
			-- Create scene object to house animation information
			local adObj = point size:0.001 pos:[0,0,0]
			adObj.name = "_M3_Anim_Data"
			adObj.renderable = off
			adObj.isHidden = true
			adObj.wirecolor = color 8 8 136
			
			aobj = adObj
		)
		-- (AppData) Update Animation Count
		local adss = stringstream ""
		format ".version:%\n" SC2PLUGIN_VERS to:adss
		format ".count:%\n" adata.count to:adss
		setAppData aobj 1 adss
		
		-- (AppData) Add Entry
		local adss = sc2_AnimToStrm ad
		local objInd = adata.count + 1
		setAppData aobj objInd adss
		
		-- update list
		List_Pop()
		Selected (adata.count + 1)
	)
	on btnRemove pressed do
	(
		local ind = dlAnim.selection - 1
		if (ind != 0) then
		(
			adata = deleteItem adata ind 
			sc2_Set_Scene_Data aobj adata -- Fix scene data
			
			-- Reset list and selection
			List_Pop()
			Selected ind
		)
	)
)

fn sc2animUIreset =
(
	-- Reset
	if (sc2animUI != undefined) do closeUtility sc2animUI
)

-- Max Reset causes Animation UI to close
callbacks.removeScripts id:#m3animrs
callbacks.removeScripts id:#m3attach
callbacks.addScript #systemPostReset "sc2animUIreset()" id:#m3animrs
callbacks.addScript #systemPostReset "sc2att_size = 0.08; sc2att_id = \"\"" id:#m3attach
callbacks.addScript #filePostOpen "sc2animUIreset()" id:#m3animrs
callbacks.addScript #filePostOpen "sc2att_size = 0.08; sc2att_id = \"\"" id:#m3attach
